<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "mapDataType".
 *
 * @property int $mapDataTypeID
 * @property string|null $mapDataTypeName
 * @property string|null $mapDataTypeSymbol
 *
 * @property DeviceMapMasterAdmin[] $deviceMapMasterAdmins
 */
class MapDataType extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'mapDataType';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['mapDataTypeName'], 'string', 'max' => 50],
            [['mapDataTypeSymbol'], 'string', 'max' => 1],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'mapDataTypeID' => 'Map Data Type ID',
            'mapDataTypeName' => 'Map Data Type Name',
            'mapDataTypeSymbol' => 'Map Data Type Symbol',
        ];
    }

    /**
     * Gets query for [[DeviceMapMasterAdmins]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDeviceMapMasterAdmins()
    {
        return $this->hasMany(DeviceMapMasterAdmin::className(), ['mapDataTypeID' => 'mapDataTypeID']);
    }
}
