<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\GaugeDial;

/**
 * GaugeDialSearch represents the model behind the search form of `app\models\GaugeDial`.
 */
class GaugeDialSearch extends GaugeDial
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['gaugeDialSettingID'], 'integer'],
            [['gaugeDialSettingName', 'gaugeDialSettingMinValue', 'gaugeDialSettingMaxValue', 'gaugeDialSettingMajorTicks', 'gaugeDialSettingMinorTicks', 'gaugeDialSettingGreenMarkStarts', 'gaugeDialSettingGreenMarkEnd', 'gaugeDialSettingRedMarkStarts', 'gaugeDialSettingRedMarkEnd', 'gaugeDialSettingAddRedMarkStarts', 'gaugeDialSettingAddRedMarkEnd'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GaugeDial::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'gaugeDialSettingID' => $this->gaugeDialSettingID,
        ]);

        $query->andFilterWhere(['like', 'gaugeDialSettingName', $this->gaugeDialSettingName])
            ->andFilterWhere(['like', 'gaugeDialSettingMinValue', $this->gaugeDialSettingMinValue])
            ->andFilterWhere(['like', 'gaugeDialSettingMaxValue', $this->gaugeDialSettingMaxValue])
            ->andFilterWhere(['like', 'gaugeDialSettingMajorTicks', $this->gaugeDialSettingMajorTicks])
            ->andFilterWhere(['like', 'gaugeDialSettingMinorTicks', $this->gaugeDialSettingMinorTicks])
            ->andFilterWhere(['like', 'gaugeDialSettingGreenMarkStarts', $this->gaugeDialSettingGreenMarkStarts])
            ->andFilterWhere(['like', 'gaugeDialSettingGreenMarkEnd', $this->gaugeDialSettingGreenMarkEnd])
            ->andFilterWhere(['like', 'gaugeDialSettingRedMarkStarts', $this->gaugeDialSettingRedMarkStarts])
            ->andFilterWhere(['like', 'gaugeDialSettingRedMarkEnd', $this->gaugeDialSettingRedMarkEnd])
            ->andFilterWhere(['like', 'gaugeDialSettingAddRedMarkStarts', $this->gaugeDialSettingAddRedMarkStarts])
            ->andFilterWhere(['like', 'gaugeDialSettingAddRedMarkEnd', $this->gaugeDialSettingAddRedMarkEnd]);

        return $dataProvider;
    }
}
