<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "gaugeDialSetting".
 *
 * @property int $gaugeDialSettingID
 * @property string|null $gaugeDialSettingName
 * @property string|null $gaugeDialSettingMinValue
 * @property string|null $gaugeDialSettingMaxValue
 * @property string|null $gaugeDialSettingMajorTicks
 * @property string|null $gaugeDialSettingMinorTicks
 * @property string|null $gaugeDialSettingGreenMarkStarts
 * @property string|null $gaugeDialSettingGreenMarkEnd
 * @property string|null $gaugeDialSettingRedMarkStarts
 * @property string|null $gaugeDialSettingRedMarkEnd
 * @property string|null $gaugeDialSettingAddRedMarkStarts
 * @property string|null $gaugeDialSettingAddRedMarkEnd
 */
class GaugeDial extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'gaugeDialSetting';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['gaugeDialSettingName', 'gaugeDialSettingMajorTicks'], 'string', 'max' => 150],
            [['gaugeDialSettingMinValue', 'gaugeDialSettingMaxValue', 'gaugeDialSettingMinorTicks', 'gaugeDialSettingGreenMarkStarts', 'gaugeDialSettingGreenMarkEnd', 'gaugeDialSettingRedMarkStarts', 'gaugeDialSettingRedMarkEnd', 'gaugeDialSettingAddRedMarkStarts', 'gaugeDialSettingAddRedMarkEnd'], 'string', 'max' => 9],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'gaugeDialSettingID' => 'Gauge Dial Setting ID',
            'gaugeDialSettingName' => 'Setting Name',
            'gaugeDialSettingMinValue' => 'Min Value',
            'gaugeDialSettingMaxValue' => 'Max Value',
            'gaugeDialSettingMajorTicks' => 'Gauge Dial Setting Major Ticks',
            'gaugeDialSettingMinorTicks' => 'Gauge Dial Setting Minor Ticks',
            'gaugeDialSettingGreenMarkStarts' => 'Gauge Dial Setting Green Mark Starts',
            'gaugeDialSettingGreenMarkEnd' => 'Gauge Dial Setting Green Mark End',
            'gaugeDialSettingRedMarkStarts' => 'Gauge Dial Setting Red Mark Starts',
            'gaugeDialSettingRedMarkEnd' => 'Gauge Dial Setting Red Mark End',
            'gaugeDialSettingAddRedMarkStarts' => 'Gauge Dial Setting Add Red Mark Starts',
            'gaugeDialSettingAddRedMarkEnd' => 'Gauge Dial Setting Add Red Mark End',
        ];
    }
}
