<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Device;

/**
 * DeviceSearch represents the model behind the search form of `app\models\Device`.
 */
class DeviceSearch extends Device
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['deviceID', 'deviceMasterID', 'modBusID', 'gatewayID', 'parentID', 'deviceReadingMeasurementID', 'deviceDataHandlingID', 'deviceDataForwardClientID', 'deviceDataForwardTypeID', 'sanctionedLoadKW', 'sanctionedLoadKVA', 'sortID', 'isLive', 'timeOut', 'delayQueryAfterResponse', 'addressMinusValue', 'ipIndex0', 'ipIndex1', 'ipIndex2', 'ipIndex3'], 'integer'],
            [['deviceName', 'deviceDataForwardURL', 'deviceDataForwardToken', 'deviceLastData'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Device::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'deviceID' => $this->deviceID,
            'deviceMasterID' => $this->deviceMasterID,
            'modBusID' => $this->modBusID,
            'gatewayID' => $this->gatewayID,
            'parentID' => $this->parentID,
            'deviceReadingMeasurementID' => $this->deviceReadingMeasurementID,
            'deviceDataHandlingID' => $this->deviceDataHandlingID,
            'deviceDataForwardClientID' => $this->deviceDataForwardClientID,
            'deviceDataForwardTypeID' => $this->deviceDataForwardTypeID,
            'sanctionedLoadKW' => $this->sanctionedLoadKW,
            'sanctionedLoadKVA' => $this->sanctionedLoadKVA,
            'sortID' => $this->sortID,
            'isLive' => $this->isLive,
            'timeOut' => $this->timeOut,
            'delayQueryAfterResponse' => $this->delayQueryAfterResponse,
            'addressMinusValue' => $this->addressMinusValue,
            'ipIndex0' => $this->ipIndex0,
            'ipIndex1' => $this->ipIndex1,
            'ipIndex2' => $this->ipIndex2,
            'ipIndex3' => $this->ipIndex3,
        ]);

        $query->andFilterWhere(['like', 'deviceName', $this->deviceName])
            ->andFilterWhere(['like', 'deviceDataForwardURL', $this->deviceDataForwardURL])
            ->andFilterWhere(['like', 'deviceDataForwardToken', $this->deviceDataForwardToken])
            ->andFilterWhere(['like', 'deviceLastData', $this->deviceLastData]);

        return $dataProvider;
    }
}
