<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\DeviceMaster;

/**
 * DeviceMasterSearch represents the model behind the search form of `app\models\DeviceMaster`.
 */
class DeviceMasterSearch extends DeviceMaster
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['deviceMasterID', 'isAvailable'], 'integer'],
            [['deviceCompany', 'deviceModel', 'deviceTypeName'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = DeviceMaster::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'deviceMasterID' => $this->deviceMasterID,
            'isAvailable' => $this->isAvailable,
        ]);

        $query->andFilterWhere(['like', 'deviceCompany', $this->deviceCompany])
            ->andFilterWhere(['like', 'deviceModel', $this->deviceModel])
            ->andFilterWhere(['like', 'deviceTypeName', $this->deviceTypeName]);

        return $dataProvider;
    }
}
