<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\DeviceMapMasterAdmin;

/**
 * DeviceMapMasterAdminSearch represents the model behind the search form of `app\models\DeviceMapMasterAdmin`.
 */
class DeviceMapMasterAdminSearch extends DeviceMapMasterAdmin
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['deviceMapMasterAdminID', 'deviceMasterID', 'mapMasterID', 'mapDataTypeID', 'gaugeDialSettingID', 'deviceMapMasterPort', 'deviceMapMasterMF', 'deviceMapMasterShowOnDashboard', 'deviceMapMasterPullData', 'deviceMapMasterReadSize', 'deviceMapMasterServerMF'], 'integer'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
       
        $query = DeviceMapMasterAdmin::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'deviceMapMasterAdminID' => $this->deviceMapMasterAdminID,
            'deviceMasterID' => $this->deviceMasterID,
            'mapMasterID' => $this->mapMasterID,
            'mapDataTypeID' => $this->mapDataTypeID,
            'gaugeDialSettingID' => $this->gaugeDialSettingID,
            'deviceMapMasterPort' => $this->deviceMapMasterPort,
            'deviceMapMasterMF' => $this->deviceMapMasterMF,
            'deviceMapMasterShowOnDashboard' => $this->deviceMapMasterShowOnDashboard,
            'deviceMapMasterPullData' => $this->deviceMapMasterPullData,
            'deviceMapMasterReadSize' => $this->deviceMapMasterReadSize,
            'deviceMapMasterServerMF' => $this->deviceMapMasterServerMF,
        ]);

        return $dataProvider;
    }
}
