<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "device".
 *
 * @property int $deviceID
 * @property string|null $deviceName
 * @property int|null $deviceMasterID
 * @property int|null $modBusID
 * @property int|null $gatewayID
 * @property int|null $parentID
 * @property int|null $deviceReadingMeasurementID
 * @property int|null $deviceDataHandlingID
 * @property int|null $deviceDataForwardClientID
 * @property int|null $deviceDataForwardTypeID
 * @property string|null $deviceDataForwardURL
 * @property string|null $deviceDataForwardToken
 * @property int|null $sanctionedLoadKW
 * @property int|null $sanctionedLoadKVA
 * @property string|null $deviceLastData
 * @property int|null $sortID
 * @property int|null $isLive
 * @property int $timeOut
 * @property int $delayQueryAfterResponse
 * @property int $addressMinusValue
 * @property int $ipIndex0
 * @property int $ipIndex1
 * @property int $ipIndex2
 * @property int $ipIndex3
 */
class Device extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'device';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['deviceMasterID', 'modBusID', 'gatewayID', 'parentID', 'deviceReadingMeasurementID', 'deviceDataHandlingID', 'deviceDataForwardClientID', 'deviceDataForwardTypeID', 'sanctionedLoadKW', 'sanctionedLoadKVA', 'sortID', 'isLive', 'timeOut', 'delayQueryAfterResponse', 'addressMinusValue', 'ipIndex0', 'ipIndex1', 'ipIndex2', 'ipIndex3'], 'integer'],
            [['timeOut', 'delayQueryAfterResponse', 'addressMinusValue', 'ipIndex0', 'ipIndex1', 'ipIndex2', 'ipIndex3'], 'required'],
            [['deviceName'], 'string', 'max' => 24],
            [['deviceDataForwardURL', 'deviceDataForwardToken'], 'string', 'max' => 10],
            [['deviceLastData'], 'string', 'max' => 7],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'deviceID' => 'Device ID',
            'deviceName' => 'Device Name',
            'deviceMasterID' => 'Device Master ID',
            'modBusID' => 'Mod Bus ID',
            'gatewayID' => 'Gateway ID',
            'parentID' => 'Parent ID',
            'deviceReadingMeasurementID' => 'Device Reading Measurement ID',
            'deviceDataHandlingID' => 'Device Data Handling ID',
            'deviceDataForwardClientID' => 'Device Data Forward Client ID',
            'deviceDataForwardTypeID' => 'Device Data Forward Type ID',
            'deviceDataForwardURL' => 'Device Data Forward Url',
            'deviceDataForwardToken' => 'Device Data Forward Token',
            'sanctionedLoadKW' => 'Sanctioned Load Kw',
            'sanctionedLoadKVA' => 'Sanctioned Load Kva',
            'deviceLastData' => 'Device Last Data',
            'sortID' => 'Sort ID',
            'isLive' => 'Is Live',
            'timeOut' => 'Time Out',
            'delayQueryAfterResponse' => 'Delay Query After Response',
            'addressMinusValue' => 'Address Minus Value',
            'ipIndex0' => 'Ip Index 0',
            'ipIndex1' => 'Ip Index 1',
            'ipIndex2' => 'Ip Index 2',
            'ipIndex3' => 'Ip Index 3',
        ];
    }

    /**
     * {@inheritdoc}
     * @return DeviceQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new DeviceQuery(get_called_class());
    }
}
