<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "clientSites".
 *
 * @property int $id
 * @property int $clientID
 * @property int $siteID
 * @property string $liveDate
 */
class ClientSites extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'clientSites';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['clientID', 'siteID'], 'required'],
            [['clientID', 'siteID'], 'integer'],
            [['liveDate'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            //'id' => 'ID',
            'clientID' => 'Client Name',
            'siteID' => 'Site Name',
            'liveDate' => 'Live Date',
        ];
    }

    /**
     * {@inheritdoc}
     * @return ClientSitesQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new ClientSitesQuery(get_called_class());
    }
}
