<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "client".
 *
 * @property int $clientID
 * @property string $clientName
 * @property string $clientDB
 * @property string $clientDomain
 * @property string|null $clientDHash
 * @property int $updateData
 * @property string $serverID
 */
class Client extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'client';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['clientName', 'clientDB', 'clientDomain', 'serverID'], 'required'],
            [['updateData'], 'integer'],
            [['clientName', 'clientDHash'], 'string', 'max' => 200],
            [['clientDB', 'clientDomain', 'serverID'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'clientID' => 'Client ID',
            'clientName' => 'Client Name',
            'clientDB' => 'Client Db',
            'clientDomain' => 'Client Domain',
            //'clientDHash' => 'Client D Hash',
            'updateData' => 'Update Data',
            'serverID' => 'Server ID',
        ];
    }

    /**
     * {@inheritdoc}
     * @return ClientQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new ClientQuery(get_called_class());
    }
}
