<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "autoReports".
 *
 * @property int $autoReportID
 * @property int|null $autoReportType
 * @property string|null $autoReportName
 * @property string|null $autoReportTime
 * @property string|null $autoReportEmails
 * @property string|null $autoReportSubject
 * @property string|null $autoReportMessage
 * @property bool|null $isLive
 */
class AutoReports extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'autoReports';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['autoReportType'], 'integer'],
            [['autoReportTime'], 'safe'],
            [['isLive'], 'boolean'],
            [['autoReportName'], 'string', 'max' => 50],
            [['autoReportEmails', 'autoReportMessage'], 'string', 'max' => 255],
            [['autoReportSubject'], 'string', 'max' => 150],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'autoReportID' => 'Auto Report ID',
            'autoReportType' => 'Auto Report Type',
            'autoReportName' => 'Auto Report Name',
            'autoReportTime' => 'Auto Report Time',
            'autoReportEmails' => 'Auto Report Emails',
            'autoReportSubject' => 'Auto Report Subject',
            'autoReportMessage' => 'Auto Report Message',
            'isLive' => 'Is Live',
        ];
    }

    /**
     * {@inheritdoc}
     * @return AutoReportsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new AutoReportsQuery(get_called_class());
    }
}
