<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "Alert".
 *
 * @property int $AlertID
 * @property int|null $AlertTypeID
 * @property int|null $AlertStatusTypeID
 * @property string|null $AlertDateTime
 * @property string|null $AlertMessage
 * @property string|null $AlertMessageTech
 * @property int|null $UserID
 * @property string|null $LastUpdateDateTime
 * @property int|null $AlertFkID
 */
class Alert extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'Alert';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['AlertTypeID', 'AlertStatusTypeID', 'UserID', 'AlertFkID'], 'integer'],
            [['AlertDateTime', 'LastUpdateDateTime'], 'safe'],
            [['AlertMessage', 'AlertMessageTech'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'AlertID' => 'Alert ID',
            'AlertTypeID' => 'Alert Type ID',
            'AlertStatusTypeID' => 'Alert Status Type ID',
            'AlertDateTime' => 'Alert Date Time',
            'AlertMessage' => 'Alert Message',
            'AlertMessageTech' => 'Alert Message Tech',
            'UserID' => 'User ID',
            'LastUpdateDateTime' => 'Last Update Date Time',
            'AlertFkID' => 'Alert Fk ID',
        ];
    }

    /**
     * {@inheritdoc}
     * @return AlertQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new AlertQuery(get_called_class());
    }
}
