<?php

namespace app\controllers;
use yii;
use app\models\QtaConfig;
use app\models\QtaConfigSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\auth\QueryParamAuth;
/**
 * QtaConfigController implements the CRUD actions for QtaConfig model.
 */
class QtaConfigController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all QtaConfig models.
     *
     * @return string
     */
    public function actionIndex()
    {

        $qparam= Yii::$app->request->queryParams;
       if(isset($qparam['gatewayID'])){
        $gatewayID=$qparam['gatewayID'];        
       }else{
        $gatewayID=1;
       }
       $connection = Yii::$app->getDb();
       $command = $connection->createCommand("SELECT * from qtaConfig where configID=$gatewayID");
        $dataProvider = $command->queryAll();

        //$searchModel = new QtaConfigSearch();
        //$dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            //'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single QtaConfig model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new QtaConfig model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new QtaConfig();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            }
        } else {
            $qparam= Yii::$app->request->queryParams;
            if(isset($qparam['gatewayID']) && $qparam['gatewayID'] !=''){
             $gatewayID=$qparam['gatewayID'];        
            }else{
             $gatewayID=1;
            }

            $connection = Yii::$app->getDb();

            $command = $connection->createCommand("SELECT * from qtaConfig where configID=$gatewayID");
        $dataProvider = $command->queryAll();

        $command = $connection->createCommand("SELECT gatewayID,gatewayName from gateway");
        $datagateway = $command->queryAll();

        $command = $connection->createCommand("SELECT * from deviceMaster");
        $datadevicemaster = $command->queryAll();

            //$model->loadDefaultValues();
        }

        //print_r($dataProvider);
        //die();

        return $this->render('create', [
            'model' => $model,
            'dataProvider'=>$dataProvider,
            'datagateway'=>$datagateway,
            'datadevicemaster'=>$datadevicemaster            
            
        ]);
    }

    /**
     * Updates an existing QtaConfig model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }else{
            $connection = Yii::$app->getDb();

            $command = $connection->createCommand("SELECT * from qtaConfig where id=$id");
        $dataProvider = $command->queryAll();

        $command = $connection->createCommand("SELECT gatewayID,gatewayName from gateway");
        $datagateway = $command->queryAll();

        $command = $connection->createCommand("SELECT * from deviceMaster");
        $datadevicemaster = $command->queryAll();
        }

        return $this->render('update', [
            'model' => $model,
            'dataProvider'=>$dataProvider,
            'datagateway'=>$datagateway,
            'datadevicemaster'=>$datadevicemaster  
        ]);
    }

    /**
     * Deletes an existing QtaConfig model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the QtaConfig model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $id ID
     * @return QtaConfig the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = QtaConfig::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
