<?php

namespace app\controllers;
use yii;
use app\models\MapMaster;
use app\models\MapMasterSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * MapMasterController implements the CRUD actions for MapMaster model.
 */
class MapMasterController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all MapMaster models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $pagesize=15;
        $qparam= Yii::$app->request->queryParams;
       if(isset($qparam['page'])){
        $page=$qparam['page'];        
       }else{
        $page=1;
       }
       $start = ($page - 1) * $pagesize;
       //$start=$page*$pagesize;
       $end=$pagesize;

       if(isset($qparam['display'])){
        $display=$qparam['display'];
        if($display==1)
          $display=0;
        else if($display==0)
          $display=1;
        $id=$qparam['id'];
        //die();
        Yii::$app->db->createCommand()
        ->update('deviceMapMasterAdmin', ['deviceMapMastershowonDashboard' => $display], "deviceMapMasterAdminID=$id")
        ->execute();
       }

       if(isset($qparam['deviceMasterID']))
       $cond=' where dmma.deviceMasterID ='.$qparam['deviceMasterID'];
       else
       $cond=' where dmma.deviceMasterID in (SELECT DISTINCT(deviceMasterID) FROM device)';

       $queryall= "SELECT distinct(mm.mapMasterCode),mm.mapMasterName,dmma.deviceMapMastershowonDashboard,dmma.deviceMapMasterAdminID FROM `deviceMapMasterAdmin` as dmma join mapMaster as mm on dmma.mapMasterID=mm.mapMasterID $cond";
        $connection = Yii::$app->getDb();
        $command1 = $connection->createCommand($queryall);        
        $dataProviderall = $command1->queryAll();

        $query= "SELECT distinct(mm.mapMasterCode),mm.mapMasterName,dmma.deviceMapMastershowonDashboard,dmma.deviceMapMasterAdminID FROM `deviceMapMasterAdmin` as dmma join mapMaster as mm on dmma.mapMasterID=mm.mapMasterID $cond limit $start,$end";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($query);        
       
        $dataProvider = $command->queryAll(); 
        //$dataProvider=array_unique($dataProvider[0]);    
            return $this->render('index', [
            'dataProviderall' => $dataProviderall,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single MapMaster model.
     * @param int $mapMasterID Map Master ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($mapMasterID)
    {
        return $this->render('view', [
            'model' => $this->findModel($mapMasterID),
        ]);
    }

    /**
     * Creates a new MapMaster model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new MapMaster();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'mapMasterID' => $model->mapMasterID]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing MapMaster model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $mapMasterID Map Master ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($mapMasterID)
    {
        $model = $this->findModel($mapMasterID);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'mapMasterID' => $model->mapMasterID]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing MapMaster model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $mapMasterID Map Master ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($mapMasterID)
    {
        $this->findModel($mapMasterID)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the MapMaster model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $mapMasterID Map Master ID
     * @return MapMaster the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($mapMasterID)
    {
        if (($model = MapMaster::findOne(['mapMasterID' => $mapMasterID])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
