<?php

namespace app\controllers;
use yii;
use app\models\MapDataType;
use app\models\MapDataTypeSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;


/**
 * MapDataTypeController implements the CRUD actions for MapDataType model.
 */
class MapDataTypeController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['GET'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all MapDataType models.
     *
     * @return string
     */
    public function actionIndex()
    {
       
        $searchModel = new MapDataTypeSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single MapDataType model.
     * @param int $mapDataTypeID Map Data Type ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($mapDataTypeID)
    {
        return $this->render('view', [
            'model' => $this->findModel($mapDataTypeID),
        ]);
    }

    /**
     * Creates a new MapDataType model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new MapDataType();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'mapDataTypeID' => $model->mapDataTypeID]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing MapDataType model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $mapDataTypeID Map Data Type ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($mapDataTypeID)
    {
        $model = $this->findModel($mapDataTypeID);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'mapDataTypeID' => $model->mapDataTypeID]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing MapDataType model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $mapDataTypeID Map Data Type ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($mapDataTypeID)
    {
        $this->findModel($mapDataTypeID)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the MapDataType model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $mapDataTypeID Map Data Type ID
     * @return MapDataType the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($mapDataTypeID)
    {
        if (($model = MapDataType::findOne(['mapDataTypeID' => $mapDataTypeID])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
