<?php

namespace app\controllers;
use yii;
use app\models\LatestData;
use app\models\MapMasterSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * MapMasterController implements the CRUD actions for MapMaster model.
 */
class LatestDataController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all MapMaster models.
     *
     * @return string
     */

    public function actionIndex()
    {


        if(isset($_REQUEST['siteID']))
            $siteID=$_REQUEST['siteID'];
        else
        $siteID=1;

        $querymeters= "SELECT d.deviceID,d.deviceName,d.modBusID,g.gatewayName FROM device d join gateway  g where d.gatewayID=g.gatewayID and g.siteID=$siteID";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querymeters);  
        $total_meters = $command->queryAll();  

        $queryheader= "select d.deviceID ,mm.mapMasterID,mm.mapMasterName 
        from mapMaster mm join device d join deviceMapMasterAdmin dmma join gateway g where dmma.mapMasterID=mm.mapMasterID and d.deviceMasterID=dmma.deviceMasterID and d.gatewayID=g.gatewayID and dmma.deviceMapMasterPullData=1  group by deviceID,mapMasterID order by mapMasterID asc";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($queryheader);  
        $headerDataProvider = $command->queryAll(); 

        $query="";
        $query= "select d.deviceName,dd.dataID,d.deviceID,mm.mapMasterName,";
        foreach($headerDataProvider as $hdata){
            $mapmname=$hdata['mapMasterName'];
            $query.="coalesce(sum(case when mm.mapMasterName = '$mapmname' then dd.data end), 0) as '$mapmname',";
        }
        
        $query.="dd.timeStamp as 'DataTime'
        from deviceDataDaily dd join mapMaster mm join device d where dd.mapMasterID=mm.mapMasterID and d.modBusID=dd.deviceID and d.gatewayID=dd.gatewayID group by dd.timeStamp , dd.deviceID order by dd.timeStamp desc limit 0,400";
        //echo $query;
        //die();
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($query);  
        $dataProvider = $command->queryAll();  
        
        //echo'<pre>';
        //print_r($dataProvider);
        //die();
        return $this->render('index', [
            'headerDataProvider' => $headerDataProvider,
            'dataProvider' => $dataProvider,
            'total_meters' => $total_meters
        ]);
    }
    


    /*public function actionIndex()
    {
        $queryheader= "select dd.deviceID ,mm.mapMasterID,mm.mapMasterName 
        from deviceData dd join mapMaster mm on dd.mapMasterID=mm.mapMasterID group by mapMasterID order by deviceID asc";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($queryheader);        
       
        $headerDataProvider = $command->queryAll(); 

        $query= "select d.deviceName,dd.dataID,dd.deviceID,
        coalesce(sum(case when mm.mapMasterName = 'Voltage' then dd.data end), 0) as 'Voltage',
        coalesce(sum(case when mm.mapMasterName = 'Average I' then dd.data end), 0) as 'Average I',
        coalesce(sum(case when mm.mapMasterName = 'PF System' then dd.data end), 0) as 'PF System',
        coalesce(sum(case when mm.mapMasterName = 'KW System' then dd.data end), 0) as 'KW System',
        coalesce(sum(case when mm.mapMasterName = 'KVA System' then dd.data end), 0) as 'KVA System',
        coalesce(sum(case when mm.mapMasterName = 'Voltage VRN' then dd.data end), 0) as 'Voltage VRN',
        coalesce(sum(case when mm.mapMasterName = 'Voltage VYN' then dd.data end), 0) as 'Voltage VYN',
        coalesce(sum(case when mm.mapMasterName = 'KVAH' then dd.data end), 0) as KVAH,
        coalesce(sum(case when mm.mapMasterName = 'KWH' then dd.data end), 0) as KWH,
        coalesce(sum(case when mm.mapMasterName = 'THD VR' then dd.data end), 0) as 'THD VR',
        coalesce(sum(case when mm.mapMasterName = 'THD IR' then dd.data end), 0) as 'THD IR',
        coalesce(sum(case when mm.mapMasterName = 'THD VY' then dd.data end), 0) as 'THD VY', 
        dd.timeStamp as 'DataTime'
        from deviceData dd join mapMaster mm , device d where dd.mapMasterID=mm.mapMasterID and d.deviceID=dd.deviceID group by dd.mapMasterID,dd.dataID order by dataID desc";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($query);        
       
        $dataProvider = $command->queryAll();       

        return $this->render('index', [
            'headerDataProvider' => $headerDataProvider,
            'dataProvider' => $dataProvider,
            //'pages' => $pages
        ]);
    }*/

    /**
     * Displays a single MapMaster model.
     * @param int $mapMasterID Map Master ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($mapMasterID=1)
    {
        if(isset($_REQUEST['siteID']))
            $siteID=$_REQUEST['siteID'];
        else
        $siteID=1;

        $querymeters= "SELECT d.deviceID,d.deviceName,d.modBusID,g.gatewayName FROM device d join gateway  g where d.gatewayID=g.gatewayID and g.siteID=$siteID";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querymeters);  
        $total_meters = $command->queryAll();  

        $queryheader= "select d.deviceID ,mm.mapMasterID,mm.mapMasterName 
        from mapMaster mm join device d join deviceMapMasterAdmin dmma join gateway g where dmma.mapMasterID=mm.mapMasterID and d.deviceMasterID=dmma.deviceMasterID and d.gatewayID=g.gatewayID and dmma.deviceMapMasterPullData=1 group by deviceID,mapMasterID order by mapMasterID asc";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($queryheader);  
        $headerDataProvider = $command->queryAll(); 

        $query="";
        $query= "select d.deviceName,dd.dataID,d.deviceID,mm.mapMasterName,";
        foreach($headerDataProvider as $hdata){
            $mapmname=$hdata['mapMasterName'];
            $query.="coalesce(sum(case when mm.mapMasterName = '$mapmname' then dd.data end), 0) as '$mapmname',";
        }
        
        $query.="dd.timeStamp as 'DataTime'
        from deviceDataDaily dd join mapMaster mm join device d where dd.mapMasterID=mm.mapMasterID and d.modBusID=dd.deviceID and  d.gatewayID=dd.gatewayID group by dd.timeStamp , dd.deviceID order by dd.timeStamp desc limit 0,5000";
        //echo $query;
        //die();
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($query);  
        $dataProvider = $command->queryAll();  
        
        //echo'<pre>';
        //print_r($dataProvider);
        //die();
        return $this->render('view', [
            'headerDataProvider' => $headerDataProvider,
            'dataProvider' => $dataProvider,
            'total_meters' => $total_meters
        ]);
    }
    /**
     * Creates a new MapMaster model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $qparam= Yii::$app->request->queryParams;
        $mapMasterID =0;
        $deviceID =0;
        $modBusIDs=0;
        //$POST_VARIABLE=Yii::$app->request->post();
        $from1='';
        $to1='';
        $mmid='';       
        $ddg=array();
        $connection = Yii::$app->getDb();
        if(isset($_REQUEST['shiftID'])){
            $shiftID=$_REQUEST['shiftID'];
        $command = $connection->createCommand("SELECT * from shifts where shiftID=$shiftID");
    }else{
        $command = $connection->createCommand("SELECT * from shifts");
    }
        $datagroup1 = $command->queryAll();

        if(count($datagroup1)>0){
            $shiftID=$datagroup1[0]['shiftID'];
            $shiftName=$datagroup1[0]['shiftName'];

            $shiftStartHour=$datagroup1[0]['shiftStartHour'];
            $shiftStartMin=$datagroup1[0]['shiftStartMin'];

            $shiftEndHour=$datagroup1[0]['shiftEndHour'];
            $shiftEndMin=$datagroup1[0]['shiftEndMin'];
        }

        $command = $connection->createCommand("SELECT * from shifts");
        $datagroup = $command->queryAll();        

        if ($this->request->isPost) {
            $shiftID= $_REQUEST['shiftID'];
            $mapMasterID= $_REQUEST['mapMasterID'];
            $daterange=$_REQUEST['datetimes1'];
            //print_r($_REQUEST);
            //die();
            if($daterange=='')
            $daterange=date('Ymd');
            $your_date = date("Ymd", strtotime($daterange));
            //$daterange = explode('-', $daterange);
            //print_r($daterange);
             //$from=$daterange[0];
             //$patern = array("/", ":", " ");
            //$from1 = str_replace($patern, "", $from);            
            //$to=$daterange[1];
            
           // $to1 = str_replace($patern, "", $to);
           
            $to1= date($your_date, strtotime('0 hours', strtotime($your_date))).$shiftEndHour.$shiftEndMin.'00';
            //echo'<BR>';
            //$to1=$startTime;
            $from1 = date($your_date, strtotime('0 hours', strtotime($your_date))).$shiftStartHour.$shiftStartMin.'00';
            $startTime=$your_date;
            $endTime=$your_date;
            //echo'<BR>';
        }else if(isset($_REQUEST['date'])){
            $shiftID=$datagroup[0]['shiftID'];
            $mapMasterID=6;
            $daterange=$_REQUEST['date'];
            $your_date = date("Ymd", strtotime($daterange));
            //$daterange = explode('-', $daterange);
            //$from1=$daterange[0];                       
            //$to1=$daterange[1];
            
            $startTime = substr($your_date, 0, -6);
            $endTime = substr($your_date, 0, -6);
            $to1= date($endTime, strtotime('0 hours', strtotime($endTime))).$shiftEndHour.$shiftEndMin.'00';
            //echo'<BR>';
            //$to1=$startTime;
            $from1 = date($startTime, strtotime('0 hours', strtotime($startTime))).$shiftStartHour.$shiftStartMin.'00';
        }else{
            $shiftID=$datagroup[0]['shiftID'];
            $mapMasterID=6;
            $startTime = date("Ymd");
            $endTime = date("Ymd");
            $to1= date($endTime, strtotime('0 hours', strtotime($endTime))).$shiftEndHour.$shiftEndMin.'00';
            //echo'<BR>';
            //$to1=$startTime;
            $from1 = date($startTime, strtotime('0 hours', strtotime($startTime))).$shiftStartHour.$shiftStartMin.'00';
        }
        
        
            
//die();
        $command = $connection->createCommand("SELECT mapMasterName from mapMaster where mapMasterID=$mapMasterID");
        $datamapmaster = $command->queryAll();
            if(count($datamapmaster)>0)
            $mapMasterName=$datamapmaster[0]['mapMasterName'];
            else
            $mapMasterName='';
        
        
        if(isset($_REQUEST['shiftID'])){            
            $shiftID=$_REQUEST['shiftID'];
        }

        if(isset($_REQUEST['siteID']))
            $siteID=$_REQUEST['siteID'];
        else
        $siteID=1;

        $querydevice= "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID,d.deviceMasterID,g.gatewayName FROM device d join gateway g join deviceData dd where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID and d.isLive=1 and g.siteID=$siteID";       
        $command = $connection->createCommand($querydevice); 
           $headerDataProvider = $command->queryAll();
           
           //print_r($datamapmaster[0]['mapMasterName']);
           //die();
            //$res=explode("_",$deviceID);
            //$deviceID=$res[1];
            //$gatewayID=$res[0];
            
$modBusIDarr=array();
$modBusIDs='';
            $fromdate = date('d M h:i A', strtotime($from1));
            $todate = date('d M h:i A', strtotime($to1));
            
            foreach($headerDataProvider as $dgdata1){
                $modBusIDarr[]=$dgdata1['deviceID'];
                }
                $modBusIDs=implode(",",$modBusIDarr);
if($modBusIDs !=''){
                 $query="";
                 $query= "select max(dd.dataID),dd.deviceID,dd.gatewayID,d.deviceName,dd.mapMasterID, ";
                 foreach($headerDataProvider as $hdata){
                     $deviceName=$hdata['deviceName'];
                     //$deviceID=$hdata['deviceID'];
                     $query.="coalesce(sum(case when d.deviceName = '$deviceName' then dd.data end), 0) as '$deviceName',";
                 }
                 $query.="dd.timeStamp
                 from deviceData dd join device d where dd.dID=d.deviceID and dd.timeStamp between '".$from1."' and '".$to1."' and dd.dID in($modBusIDs) and dd.mapMasterID =$mapMasterID group by dd.timeStamp,dd.deviceID order by dd.timeStamp desc";
                 //echo $query;
                 //die();
                 $connection = Yii::$app->getDb();
                 $command = $connection->createCommand($query); 
                 $dataProvider = $command->queryAll(); 
                }else{
                    $dataProvider=[];
                    $headerDataProvider=[];
                }
                /*$querymapmaster= "SELECT distinct(mapMaster.mapMasterID),mapMaster.mapMasterName FROM `mapMaster` join deviceData on deviceData.mapMasterID=mapMaster.mapMasterID where deviceData.deviceID in($devid)";        
                $connection = Yii::$app->getDb();
                $command = $connection->createCommand($querymapmaster); 
                $mapmasterData = $command->queryAll(); 
                foreach($mapmasterData as $mmdata){
                    $mmarray[]=$mmdata['mapMasterID'];
                } */           
                $hourdiff = round((strtotime($to1) - strtotime($from1))/3600, 1);
                $daysdiff = round(((strtotime($to1) - strtotime($from1))/3600)/24, 0);
                return $this->render('create', [
                'mapmasterData' => [],            
                'devicedata' => [],
                'headerDataProvider' => $headerDataProvider,
                'dataProvider' => $dataProvider,
                'mmid'=>[],
                'mapMasterName'=>$datamapmaster[0]['mapMasterName'],
                'dataFrom'=> $fromdate.' to '.$todate,
                'shiftName'=>$shiftName,            
                'mapMasterID'=>$mapMasterID,
                'modBusIDs'=>$modBusIDs,
                'gatewayID'=>'',
                'daterange'=>$from1.'-'.$to1,
                'hourdiff'=>$hourdiff,
                'daysdiff'=>$daysdiff,
                'start_date'=>$startTime,
                'end_date'=>$endTime,
                'datagroup'=>$datagroup,
                'shiftStartHour'=>$shiftStartHour,
                'shiftEndHour'=>$shiftEndHour
                    ]);
                
    }


    /**
     * Updates an existing MapMaster model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $mapMasterID Map Master ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($mapMasterID)
    {
        $model = $this->findModel($mapMasterID);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'mapMasterID' => $model->mapMasterID]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing MapMaster model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $mapMasterID Map Master ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($mapMasterID)
    {
        $this->findModel($mapMasterID)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the MapMaster model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $mapMasterID Map Master ID
     * @return MapMaster the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($mapMasterID)
    {
        if (($model = MapMaster::findOne(['mapMasterID' => $mapMasterID])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
