<?php

namespace app\controllers;

use app\models\GaugeDial;
use app\models\GaugeDialSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * GaugeDialController implements the CRUD actions for GaugeDial model.
 */
class GaugeDialController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all GaugeDial models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new GaugeDialSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single GaugeDial model.
     * @param int $gaugeDialSettingID Gauge Dial Setting ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($gaugeDialSettingID)
    {
        return $this->render('view', [
            'model' => $this->findModel($gaugeDialSettingID),
        ]);
    }

    /**
     * Creates a new GaugeDial model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new GaugeDial();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'gaugeDialSettingID' => $model->gaugeDialSettingID]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing GaugeDial model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $gaugeDialSettingID Gauge Dial Setting ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($gaugeDialSettingID)
    {
        $model = $this->findModel($gaugeDialSettingID);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'gaugeDialSettingID' => $model->gaugeDialSettingID]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing GaugeDial model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $gaugeDialSettingID Gauge Dial Setting ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($gaugeDialSettingID)
    {
        $this->findModel($gaugeDialSettingID)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the GaugeDial model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $gaugeDialSettingID Gauge Dial Setting ID
     * @return GaugeDial the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($gaugeDialSettingID)
    {
        if (($model = GaugeDial::findOne(['gaugeDialSettingID' => $gaugeDialSettingID])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
