<?php

namespace app\controllers;
use yii;
use app\models\Gateway;
use app\models\GatewaySearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * GatewayController implements the CRUD actions for Gateway model.
 */
class GatewayController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['GET'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all Gateway models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $qparam= Yii::$app->request->queryParams;
        if(isset($qparam['display'])){
            $display=$qparam['display'];
            if($display==1)
              $display=0;
            else if($display==0)
              $display=1;
            $id=$qparam['id'];
            //die();
            Yii::$app->db->createCommand()
            ->update('gateway', ['isLive' => $display], "gatewayID=$id")
            ->execute();
           }

        $query= "SELECT g.gatewayID,g.siteID,g.gatewayName,g.gatewaySerialnumber,g.gatewayTypeID,g.isLive,g.gatewayMobileNumber,g.dataInterval,g.baudRate,g.retryCount,g.deviceType,gt.gatewayTypeModel,gt.gatewayTypeName FROM `gateway` g,gatewayType gt where g.gatewayTypeID=gt.gatewayTypeID";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($query);        
       
        $dataProvider = $command->queryAll();  
        
        $query1= "SELECT * from gatewayType";
        $connection1 = Yii::$app->getDb();
        $command1 = $connection1->createCommand($query1);        
       
        $datagatewayType = $command1->queryAll();  

        return $this->render('index', [
            'datagatewayType' => $datagatewayType,
            'dataProvider' => $dataProvider,
            //'pages' => $pages
        ]);
    }


    /**
     * Displays a single Gateway model.
     * @param int $gatewayID Gateway ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($gatewayID)
    {
        return $this->render('view', [
            'model' => $this->findModel($gatewayID),
        ]);
    }

    /**
     * Creates a new Gateway model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new Gateway();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'gatewayID' => $model->gatewayID]);
            }
        } else {
            $query= "SELECT g.gatewayID,g.siteID,g.gatewayName,g.gatewaySerialnumber,g.gatewayTypeID,g.isLive,g.gatewayMobileNumber,g.dataInterval,g.baudRate,g.retryCount,g.deviceType,gt.gatewayTypeModel,gt.gatewayTypeName FROM `gateway` g,gatewayType gt where g.gatewayTypeID=gt.gatewayTypeID";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($query); 
        $dataProvider = $command->queryAll(); 

            $connection = Yii::$app->getDb();
            $command = $connection->createCommand("SELECT siteID, siteName from sites");
            $datasite = $command->queryAll();
            $model->loadDefaultValues();
        }

        $query1= "SELECT * from gatewayType";
        $connection1 = Yii::$app->getDb();
        $command1 = $connection1->createCommand($query1);        
       
        $datagatewayType = $command1->queryAll();  

        return $this->render('create', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'datagatewayType'=>$datagatewayType,
            'datasite'=>$datasite
        ]);
    }

    /**
     * Updates an existing Gateway model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $gatewayID Gateway ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($gatewayID)
    {
        $model = $this->findModel($gatewayID);

        $connection = Yii::$app->getDb();
            $command = $connection->createCommand("SELECT siteID, siteName from sites");
            $datasite = $command->queryAll();

if ($this->request->isPost && $model->load(Yii::$app->request->post()) && $model->save()) {
    $postdata=$this->request->post();
    //print_r($postdata['Gateway']['siteID']);
//die();
    $siteID=$postdata['Gateway']['siteID'];
    $gatewaySerialNumber=$postdata['Gateway']['gatewaySerialNumber'];
    $gatewayName=$postdata['Gateway']['gatewayName'];
    $dataInterval=$postdata['Gateway']['dataInterval'];
    $lineControl=$postdata['Gateway']['lineControl'];
    $baudRate=$postdata['Gateway']['baudRate'];
    $retryCount=$postdata['Gateway']['retryCount'];
    $deviceType=$postdata['Gateway']['deviceType'];
    $gatewayDataURL=$postdata['Gateway']['gatewayDataURL'];
    $isLive=$postdata['Gateway']['isLive'];
    $statusInterval=$postdata['Gateway']['statusInterval'];

    $connection = Yii::$app->getDb();
    $command = $connection->createCommand("UPDATE gateway SET siteID=$siteID,gatewaySerialNumber='$gatewaySerialNumber',gatewayName='$gatewayName',dataInterval='$dataInterval',lineControl='$lineControl',baudRate=$baudRate,retryCount=$retryCount,deviceType='$deviceType',gatewayDataURL='$gatewayDataURL',isLive=$isLive,statusInterval=$statusInterval,updateConfigure=1 WHERE gatewayID=$gatewayID");
    $command->execute();


      //  if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            
//print_r($this->request->post());
 //die();
            return $this->redirect(['view', 'gatewayID' => $model->gatewayID]);
        }

        $query= "SELECT g.gatewayID,g.siteID,g.gatewayName,g.gatewaySerialnumber,g.gatewayTypeID,g.isLive,g.gatewayMobileNumber,g.dataInterval,g.baudRate,g.retryCount,g.deviceType,gt.gatewayTypeModel,gt.gatewayTypeName FROM `gateway` g,gatewayType gt where g.gatewayTypeID=gt.gatewayTypeID and g.gatewayID=$gatewayID";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($query); 
        $dataProvider = $command->queryAll(); 

        $query1= "SELECT * from gatewayType";
        $connection1 = Yii::$app->getDb();
        $command1 = $connection1->createCommand($query1);        
       
        $datagatewayType = $command1->queryAll();  

        return $this->render('update', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'datagatewayType'=>$datagatewayType,
            'datasite'=>$datasite
        ]);
    }

    /**
     * Deletes an existing Gateway model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $gatewayID Gateway ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($gatewayID)
    {
        $this->findModel($gatewayID)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Gateway model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $gatewayID Gateway ID
     * @return Gateway the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($gatewayID)
    {
        if (($model = Gateway::findOne(['gatewayID' => $gatewayID])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
