<?php

namespace app\controllers;

use app\models\DeviceMaster;
use app\models\DeviceMasterSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * DeviceMasterController implements the CRUD actions for DeviceMaster model.
 */
class DeviceMasterController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['GET'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all DeviceMaster models.
     *
     * @return string
     */
    public function actionIndex()
    {
       /* $qparam= Yii::$app->request->queryParams;
        if(isset($qparam['display'])){
            $display=$qparam['display'];
            if($display==1)
              $display=0;
            else if($display==0)
              $display=1;
            $id=$qparam['id'];
            //die();
            Yii::$app->db->createCommand()
            ->update('deviceMaster', ['isAvailable' => $display], "deviceMasterID=$id")
            ->execute();
           }
*/

        $searchModel = new DeviceMasterSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single DeviceMaster model.
     * @param int $deviceMasterID Device Master ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($deviceMasterID)
    {
        return $this->render('view', [
            'model' => $this->findModel($deviceMasterID),
        ]);
    }

    /**
     * Creates a new DeviceMaster model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new DeviceMaster();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'deviceMasterID' => $model->deviceMasterID]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing DeviceMaster model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $deviceMasterID Device Master ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($deviceMasterID)
    {
        $model = $this->findModel($deviceMasterID);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'deviceMasterID' => $model->deviceMasterID]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing DeviceMaster model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $deviceMasterID Device Master ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($deviceMasterID)
    {
        $this->findModel($deviceMasterID)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the DeviceMaster model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $deviceMasterID Device Master ID
     * @return DeviceMaster the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($deviceMasterID)
    {
        if (($model = DeviceMaster::findOne(['deviceMasterID' => $deviceMasterID])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
