<?php

namespace app\controllers;

use yii;
use app\models\ClientSites;
use app\models\ClientSitesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * ClientSitesController implements the CRUD actions for ClientSites model.
 */
class ClientSitesController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all ClientSites models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $query= "SELECT cs.*,s.siteName,c.clientName from clientSites as cs join sites as s join client as c on cs.clientID=c.clientID and cs.siteID=s.siteID";
        $connection = Yii::$app->getDb();    
        $command = $connection->createCommand($query);
        $dataProvider = $command->queryAll();  

        return $this->render('index', [
            //'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ClientSites model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ClientSites model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new ClientSites();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            }
        } else {

            $query= "SELECT cs.*,s.siteName,c.clientName from clientSites as cs join sites as s join client as c on cs.clientID=c.clientID and cs.siteID=s.siteID";
            $connection = Yii::$app->getDb();    
            $command = $connection->createCommand($query);
            $dataProvider = $command->queryAll();

            $connection = Yii::$app->getDb();
            $command = $connection->createCommand("SELECT siteID, siteName from sites");
            $datasite = $command->queryAll();    
    
            $command = $connection->createCommand("SELECT clientID,clientName from client");
            $dataclient = $command->queryAll();

            //$model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'datasite'=> $datasite,
            'dataclient'=> $dataclient
        ]);
    }

    /**
     * Updates an existing ClientSites model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }else{

            $query= "SELECT cs.*,s.siteName,c.clientName from clientSites as cs join sites as s join client as c on cs.clientID=c.clientID 
            and cs.siteID=s.siteID where cs.id=$id";
            $connection = Yii::$app->getDb();    
            $command = $connection->createCommand($query);
            $dataProvider = $command->queryAll();

            $connection = Yii::$app->getDb();
            $command = $connection->createCommand("SELECT siteID, siteName from sites");
            $datasite = $command->queryAll();    
    
            $command = $connection->createCommand("SELECT clientID,clientName from client");
            $dataclient = $command->queryAll();

            return $this->render('create', [
                'model' => $model,
                'dataProvider' => $dataProvider,
                'datasite'=> $datasite,
                'dataclient'=> $dataclient
            ]);

        }
       
    }

    /**
     * Deletes an existing ClientSites model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the ClientSites model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $id ID
     * @return ClientSites the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = ClientSites::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
